/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.kubejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.Locale;
import novamachina.exnihilosequentia.common.blockentity.crucible.CrucibleTypeEnum;
import novamachina.exnihilosequentia.common.compat.kubejs.BaseRecipeJS;

public class CrucibleRecipeJS
extends BaseRecipeJS {
    public void create(ListJS args) {
        this.inputItems.add(this.parseIngredientItem(args.get(0)));
        this.crucibleType(args.get(1));
        this.amount(((Number)args.get(2)).intValue());
        this.fluidResult(FluidStackJS.of((Object)args.get(3)));
    }

    private void fluidResult(FluidStackJS fluidStack) {
        JsonObject object = new JsonObject();
        object.addProperty("fluid", fluidStack.getId());
        this.json.add("fluidResult", (JsonElement)object);
    }

    private void amount(int intValue) {
        this.json.addProperty("amount", (Number)intValue);
    }

    private void crucibleType(Object o) {
        String type;
        block3: {
            block2: {
                if (!(o instanceof String)) break block2;
                type = (String)o;
                if (this.validCrucibleType((String)o)) break block3;
            }
            throw new RecipeExceptionJS("Crucible recipe must have a crucible type of 'wood' or 'fired'");
        }
        this.json.addProperty("crucibleType", type.toLowerCase(Locale.ROOT));
    }

    private boolean validCrucibleType(String name) {
        for (CrucibleTypeEnum type : CrucibleTypeEnum.values()) {
            if (!type.getName().toLowerCase(Locale.ROOT).equals(name.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deserialize() {
        this.inputItems.add(this.parseIngredientItem(this.json.get("input")));
    }

    @Override
    public void serialize() {
        if (this.serializeInputs) {
            this.json.add("input", ((IngredientJS)this.inputItems.get(0)).toJson());
        }
    }
}

